/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package chapter8;

import concurrentCollections.*;
import executorServices.*;
import forkJoin.*;
import synchronisers.*;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;


/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class StartHere {
    public static void main(String[] args) {
        
        //Executor Services
//        ExecutorService es = Executors.newFixedThreadPool(4);
//        ExampleRunnable task = new ExampleRunnable();
//        es.execute(task);//Set the first thread running
//        es.execute(task);//Set a second thread running
//        es.execute(task);//Set a third thread running
//        es.execute(new Runnable(){public void run() {System.out.println("Third thread runs");}});
//        es.shutdown();//Close everything down when finished.
 
//        int count = Runtime.getRuntime().availableProcessors();
//        System.out.println("Processor Count:" + count);
        
        //Passing parameters
        
//        ExecutorService es = Executors.newFixedThreadPool(4);
//        ExampleRunnableWithParameters task = 
//        new ExampleRunnableWithParameters(23,14,2,6,12,16,19);
//        es.execute(task);//Set the first thread running
//        es.execute(task);//Set a second thread running
//        es.execute(task);//Set a third thread running
//        es.shutdown();//Close everything down 

        //Returning Values
        //First attempt
//        System.out.println("Total for task is: "+task.sum);
        //Using a callable task
//        ExampleCallable task = 
//            new ExampleCallable(23,14,2,6,12,16,19);
//        es.submit(task);//Set the first thread running
//        es.submit(task);//Set a second thread running
//        es.submit(task);//Set a third thread running
//        es.shutdown();//Close everything down 
        //Using a future class to get result
//        Future<String> sum = es.submit(task);//Set the first thread running
//        es.submit(task);//Set a second thread running
//        es.submit(task);//Set a third thread running
//        while (!sum.isDone()) TakeABreak.sleep();
//        try{
//            System.out.println(sum.get());
//        } catch (Exception e){};
//        es.shutdown();//Close everything down 
        
        
        //Concurrency Collections
//        PriorityQueue myQueue = new PriorityQueue();
//        Thread producerThread = new Thread(new Producer(myQueue));
//        Thread consumerThread  = new Thread(new Consumer(myQueue));
//        Thread consumerThread2  = new Thread(new Consumer(myQueue));
//        producerThread.start();
//        consumerThread.start();
//        consumerThread2.start();
        //Concurrent version
//        PriorityBlockingQueue myQueue = new PriorityBlockingQueue();
//        Thread producerThread = new Thread(new Producer(myQueue));
//        Thread consumerThread  = new Thread(new Consumer(myQueue));
//        Thread consumerThread2  = new Thread(new Consumer(myQueue));
//        producerThread.start();
//        consumerThread.start();
//        consumerThread2.start();
        
        //Synchroniser
//        CyclicBarrierExample.main(args);
        
        //Fork Join
        ForkJoinPool fjp = new ForkJoinPool();
        int[] numbers = {23,14,2,6,12,16,19};
        ExampleForkJoin task = 
                    new ExampleForkJoin(numbers,0,numbers.length);
//        System.out.println("Start execute.");
        fjp.invoke(task);
//        System.out.println("End execute.");
    }
}
